<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Backupdr;

class BackupPlanAssociation extends \Google\Collection
{
  protected $collection_key = 'rulesConfigInfo';
  /**
   * @var string
   */
  public $backupPlan;
  /**
   * @var string
   */
  public $backupPlanRevisionId;
  /**
   * @var string
   */
  public $backupPlanRevisionName;
  protected $cloudSqlInstanceBackupPlanAssociationPropertiesType = CloudSqlInstanceBackupPlanAssociationProperties::class;
  protected $cloudSqlInstanceBackupPlanAssociationPropertiesDataType = '';
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $dataSource;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $resource;
  /**
   * @var string
   */
  public $resourceType;
  protected $rulesConfigInfoType = RuleConfigInfo::class;
  protected $rulesConfigInfoDataType = 'array';
  /**
   * @var string
   */
  public $state;
  /**
   * @var string
   */
  public $updateTime;

  /**
   * @param string
   */
  public function setBackupPlan($backupPlan)
  {
    $this->backupPlan = $backupPlan;
  }
  /**
   * @return string
   */
  public function getBackupPlan()
  {
    return $this->backupPlan;
  }
  /**
   * @param string
   */
  public function setBackupPlanRevisionId($backupPlanRevisionId)
  {
    $this->backupPlanRevisionId = $backupPlanRevisionId;
  }
  /**
   * @return string
   */
  public function getBackupPlanRevisionId()
  {
    return $this->backupPlanRevisionId;
  }
  /**
   * @param string
   */
  public function setBackupPlanRevisionName($backupPlanRevisionName)
  {
    $this->backupPlanRevisionName = $backupPlanRevisionName;
  }
  /**
   * @return string
   */
  public function getBackupPlanRevisionName()
  {
    return $this->backupPlanRevisionName;
  }
  /**
   * @param CloudSqlInstanceBackupPlanAssociationProperties
   */
  public function setCloudSqlInstanceBackupPlanAssociationProperties(CloudSqlInstanceBackupPlanAssociationProperties $cloudSqlInstanceBackupPlanAssociationProperties)
  {
    $this->cloudSqlInstanceBackupPlanAssociationProperties = $cloudSqlInstanceBackupPlanAssociationProperties;
  }
  /**
   * @return CloudSqlInstanceBackupPlanAssociationProperties
   */
  public function getCloudSqlInstanceBackupPlanAssociationProperties()
  {
    return $this->cloudSqlInstanceBackupPlanAssociationProperties;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setDataSource($dataSource)
  {
    $this->dataSource = $dataSource;
  }
  /**
   * @return string
   */
  public function getDataSource()
  {
    return $this->dataSource;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setResource($resource)
  {
    $this->resource = $resource;
  }
  /**
   * @return string
   */
  public function getResource()
  {
    return $this->resource;
  }
  /**
   * @param string
   */
  public function setResourceType($resourceType)
  {
    $this->resourceType = $resourceType;
  }
  /**
   * @return string
   */
  public function getResourceType()
  {
    return $this->resourceType;
  }
  /**
   * @param RuleConfigInfo[]
   */
  public function setRulesConfigInfo($rulesConfigInfo)
  {
    $this->rulesConfigInfo = $rulesConfigInfo;
  }
  /**
   * @return RuleConfigInfo[]
   */
  public function getRulesConfigInfo()
  {
    return $this->rulesConfigInfo;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BackupPlanAssociation::class, 'Google_Service_Backupdr_BackupPlanAssociation');
